//
//  GlyphsPluginProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 13.04.13.
//  Copyright 2013 schriftgestaltung.de. All rights reserved.
//

typedef NS_ENUM(NSUInteger, GSPluginType) {
	GSPluginTypeGeneral,
	GSPluginTypeFileFormat,
	GSPluginTypeFilter,
	GSPluginTypePalette,
	GSPluginTypeReporter,
	GSPluginTypeTool
};

NSArray *GSProtocolsForPluginType(GSPluginType pluginType);

NSString *GSSuffixForPluginType(GSPluginType pluginType);

BOOL GSInstanceConformsToProtocols(Class aClass, NSArray<Protocol *> *protocols);

GSPluginType GSPluginTypeForExtension(NSString *extension);
/** GlyphsPlugin: The protocol defining the general plugin interface
 */
@protocol GlyphsPlugin

/** The interface version.
 Return 1 for now
 */
@property (nonatomic, readonly) NSUInteger interfaceVersion;

/** Is called to let the plugin initialise itself */
- (void)loadPlugin;
@end
